extends RigidBody

var type = 1

var level = 1

var material = null

var grounded = false
var hit_by_birb = false
var safe = false

var hit_color = Color(2, 2, 2)
var normal_color = Color(1,1,1)

var rng = RandomNumberGenerator.new()

signal on_ground(brick, was_hit_by_birb)
signal game_over()

func _ready():
	material = $BrickMesh.get_active_material(0)
	material.albedo_color = normal_color
	rng.randomize()

func init(brick_level):
	level = brick_level
	print('level set to ' + str(level))
	
func hit():
	hit_by_birb = true
	material.albedo_color = hit_color


func _on_BrickRigidBody_body_entered(body):
	if not "type" in body:
		return
	
	if body.type == 1:
		var vel_diff = (body.get_linear_velocity() - get_linear_velocity()).length()
		if vel_diff > 2:	
			$noise.play()
	if level == 1:
		if safe:
			return
		if hit_by_birb:
			emit_signal('on_ground', self, hit_by_birb)
			safe = true
	if not grounded and level != 1 and body.type == 0:
		
		$noise.play()
		grounded = true
		if safe: 
			return
		if hit_by_birb:
			emit_signal('on_ground', self, hit_by_birb)
			safe = true
		else: 
			emit_signal('game_over')
			
			
func reset():
	if get_linear_velocity().length() < .5:
		hit_by_birb = false
		material.albedo_color = normal_color
	
func explode():
	var x = .5 - rng.randf()
	var y = .5 - rng.randf()
	var direction = Vector3(x, 2, y)
	var magnitude = rng.randf() * 3000 + 1000
	add_central_force(direction*magnitude)
