extends Spatial

var gravity_amt = 0
var gravity_vector = Vector3.ZERO

var lost = false

var MOUSE_SENSITIVITY = 0.05

var tutorial_active = true

signal reset()

func _ready():
	gravity_vector = PhysicsServer.area_get_param(get_world().get_space(), PhysicsServer.AREA_PARAM_GRAVITY_VECTOR)
	gravity_amt = PhysicsServer.area_get_param(get_world().get_space(), PhysicsServer.AREA_PARAM_GRAVITY)

	Input.set_mouse_mode(Input.MOUSE_MODE_CAPTURED)
	$birb.reset()

func handle_fire():
	$birb.fire()
	$FireNoise.play()
	
func handle_reset():
	if lost:
		$Bricks.respawn()
		lost = false
		emit_signal("reset")
	$birb.reset()
	var camera_rot = $CameraRoot.rotation.y
	$birb.re_aim(camera_rot + PI/20)
	
func handle_rotate_right(delta):
	$CameraRoot.rotate_y(-1 * delta)
	if $birb.aiming:
		var camera_rot = $CameraRoot.rotation.y
		$birb.re_aim(camera_rot + PI/20)
		
func handle_rotate_left(delta):
	$CameraRoot.rotate_y(1 * delta)
	if $birb.aiming:
		var camera_rot = $CameraRoot.rotation.y
		$birb.re_aim(camera_rot + PI/20)
	
func _handle_tutorial_press(action, delta):
	if action == 'fire':
		handle_fire()
	if action == 'reset':
		handle_reset()
	if action == 'rotate_left':
		handle_rotate_left(delta)
	if action == 'rotate_right':
		handle_rotate_right(delta)
	else:
		$birb.handle_action(action, delta)
	
func _input(event):
	if event is InputEventMouseMotion and Input.is_action_pressed('rotate_camera'):
		$CameraRoot.rotate_y(deg2rad(event.relative.x * MOUSE_SENSITIVITY * -1))
		if $birb.aiming:
			var camera_rot = $CameraRoot.rotation.y
			$birb.re_aim(camera_rot + PI/20)
	
	if tutorial_active:
		return false
	
	if Input.is_action_pressed('fire'):
		handle_fire()
	if Input.is_action_pressed('reset'):
		handle_reset()


func _process(delta):

	if Input.is_action_just_pressed("ui_cancel"):
		if Input.get_mouse_mode() == Input.MOUSE_MODE_VISIBLE:
			Input.set_mouse_mode(Input.MOUSE_MODE_CAPTURED)
		else:
			Input.set_mouse_mode(Input.MOUSE_MODE_VISIBLE)
			
	if tutorial_active:
		return false

	if Input.is_action_pressed('rotate_left'):
		handle_rotate_left(delta)
	if Input.is_action_pressed('rotate_right'):
		handle_rotate_right(delta)
	if Input.is_action_pressed('aim_up'):
		$birb.handle_action('aim_up', delta)
	if Input.is_action_pressed('aim_down'):
		$birb.handle_action('aim_down', delta)
	if Input.is_action_pressed('aim_right'):
		$birb.handle_action('aim_right', delta)
	if Input.is_action_pressed('aim_left'):
		$birb.handle_action('aim_left', delta)
	if Input.is_action_pressed('aim_harder'):
		$birb.handle_action('aim_harder', delta)
	if Input.is_action_pressed('aim_softer'):
		$birb.handle_action('aim_softer', delta)

func _on_birb_aim_updated(amount):
	var delta = 1/20.0
	var birb_position = $birb.get_transform().origin
	var birb_force_vector = $birb.direction	* $birb.force_magnitude

	var birb_vel = birb_force_vector
	
	var pos = birb_position
	var vel = birb_vel
	var birb_gravity = gravity_vector * gravity_amt
	var points = []
	for _i in range(20):
		var change = birb_gravity * delta
		
		vel += change
		#vel *= .9988  # handle linear damping
		
		points.append(pos)
		pos += vel * delta
		
	$trajectory.points = points

func _on_birb_body_entered(body):
	$BirbNoise.play()
	if body.type == 1:
		body.hit()


func _on_Bricks_game_over():
	lost = true
	$FailNoise.play()


func _on_UI_tutorial_finished():
	tutorial_active = false


func _on_Camera_ready():
	$birb.reset()
	var camera_rot = $CameraRoot.rotation.y
	$birb.re_aim(camera_rot + PI/20)
